TITLE   'Electrons at a Metal-Vacuum Interface'	         { exa211x.pde }
SELECT     errlim=1e-4
COORDINATES
   cartesian1
VARIABLES   Ex
DEFINITIONS
   Lx=1e-10     Lc=Lx/2
   J0=0     Ex0=1e3 						{ External Ex }
   q=1.60e-19     kb=1.38e-23    eps=8.85e-12     temp=300
   cond     ne0        				
   mue=cond/q/ne0     De=mue*kb*temp/q     rho=dx( eps*Ex) 		
   F_ex=0.5*eps*Ex0^2						{ Force }
EQUATIONS
   q*mue*ne0*Ex- mue*dx( eps*Ex)*Ex- De*del2( eps*Ex)=J0
BOUNDARIES
region 'domain'  cond=1.0  ne0=1.0
   start (-Lx)  point value( Ex)=Ex0
   line to (Lx)  point value( Ex)=Ex0
region 'copper'  cond= 5e7  ne0=1.0e29
   start(-Lc)  mesh_spacing=0.01*Lx  line to (Lc)	  { Denser at interface }
PLOTS
   elevation( Ex) from (-Lx) to (Lx)
   elevation( rho*Ex) from (0) to (Lc) report(F_ex)
END

